using UnityEngine;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using Newtonsoft.Json;

public class QKGame {
#if UNITY_IOS
    [DllImport("__Internal")]
    private static extern void LuluSetListener(string gameObjectName);
    public void loginKitSetListener(LoginKitListener listener)
    {
        Debug.Log("gameObject is " + listener.gameObject.name);
        if (listener == null)
        {
            Debug.LogError("set LoginKitListener error, listener is null");
            return;
        }
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            string gameObjectName = listener.gameObject.name;
            LuluSetListener(gameObjectName);
        }
    }
	 [DllImport("__Internal")]  
     private static extern void luLuInit();
	//init
	public static void txQKInit()
	{
		if (Application.platform != RuntimePlatform.OSXEditor)   
        {  
			luLuInit();
        }  
	}
	 [DllImport("__Internal")]  
     private static extern void luLuLogin(bool isShowMenu);
	 //Login
     public static void txQKLogin (bool isShowMenu)
     {  
        if (Application.platform != RuntimePlatform.OSXEditor)
        {  
			luLuLogin(isShowMenu); 
        }  
     }
    [DllImport("__Internal")]
     private static extern void luLuLoginWithType(int type);
     //Login
     public static void loginKitLoginWithType(int type)
     {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuLoginWithType(type);
        }
     }
     [DllImport("__Internal")]
     private static extern void luLuFastStartGame();
     //Login
     public static void txQKFastStartGame()
     {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuFastStartGame();
        }
     }
     [DllImport("__Internal")]
     private static extern string luLuGetUserBindInfo();
     //luLuUserCenter
     public static Dictionary<string, int> loginkitGetUserBindInfo()
     {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                string jsonString = luLuGetUserBindInfo();
                var dic = Newtonsoft.Json.JsonConvert.DeserializeObject<Dictionary<string, bool>>(jsonString);
                return dic;
            }
            catch
            {
                Debug.Log("[QKGame] GetUserBindInfo : Fail to DeserializeObject");
                return new Dictionary<string, int>();
            }
        }
        return new Dictionary<string, int>();
     }
     [DllImport("__Internal")]  
     private static extern void luLuUserCenter();  
     //luLuUserCenter
     public static void txQKCenter()
     {  
        if (Application.platform != RuntimePlatform.OSXEditor)   
        {  
			luLuUserCenter(); 
        }  
     }
	 [DllImport("__Internal")]
	 private static extern void luLuLogout();
	 //Logout
	 public static void txQKLogout()
	 {
		if (Application.platform != RuntimePlatform.OSXEditor)   
		{  
			luLuLogout(); 
		}  
	 }
     [DllImport("__Internal")]
    private static extern void luLuBindAccount();
    //bindAccount
    public static void txQKBindAccount()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuBindAccount();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuBindAccountWithType(int type);
    //bindAccountType
    public static void txQKBindAccountWithType(int type)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuBindAccountWithType(type);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuUnbindAccountWithType(int type);
    //unbindAccountType
    public static void txQKUnbindAccountWithType(int type)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuUnbindAccountWithType(type);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuAccountDeletion();
    //accountDeletion
    public static void txQKAccountDeletion()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuAccountDeletion();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuAccountDeletionWithoutConfirm();
    //accountDeletion
    public static void txQKDeletionWithoutConfirm()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuAccountDeletionWithoutConfirm();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuShowMenu(float y);
    //luLuShowMenu
    public static void txQKShowMenu(float y)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuShowMenu(y);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuDismissMenu();
    //luLuDismissMenu
    public static void txQKDismissMenu()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuDismissMenu();
        }
    }
    [DllImport("__Internal")]
     private static extern void luluSetRoleInfo(string serverName,string serverId,string roleId,string roleName,string roleLevel,string roleVipLevel);
    //setRoleInfo,参数 游戏服名 游戏服id 角色名 角色id 角色等级 角色vip等级
    public static void txQKSetRoleInfo(string serverName,string serverId,string roleId,string roleName,string roleLevel,string roleVipLevel)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luluSetRoleInfo(serverName,serverId,roleId,roleName,roleLevel,roleLevel);
        }
    }
	[DllImport("__Internal")]  
	private static extern void luLuCongzi(string productId,string productName,string amount,string orderNo,string callBackUrl,string extrasParams);
	//Pay RMB,参数 苹果商品ID 商品名称 价格 游戏订单号 游戏收单服务器地址 透传参数
	public static void txQKCongzi(string productId,string productName,string amount,string orderNo,string callBackUrl,string extrasParams)
	{  
		if (Application.platform != RuntimePlatform.OSXEditor)   
		{  
			luLuCongzi(productId,productName,amount,orderNo,callBackUrl,extrasParams);
		}  
	}
    [DllImport("__Internal")]
    private static extern void luluRestoreNonConsumptionProducts();
    //lulurestoreNonConsumptionProducts
    public static void txQKRestoreNonConsumptionProducts()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luluRestoreNonConsumptionProducts();
        }
    }
    [DllImport("__Internal")]
    private static extern void luluFindProductInfo(string productIds);
    //luLuDismissMenu
    public static void txQKFindProductInfo(List<string> goodsIds)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            string strJson = JsonConvert.SerializeObject(goodsIds):
            luluFindProductInfo(strJson);
        }
    }
    [DllImport("__Internal")]
    private static extern string LuluGetUserId();
    public string loginKitGetUserId()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            return LuluGetUserId();
        }
        return string.Empty;
    }
    [DllImport("__Internal")]
    private static extern string LuluGetDeviceId();
    public string loginKitGetDeviceId()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            return LuluGetDeviceId();
        }
        return string.Empty;
    }
    [DllImport("__Internal")]
    private static extern void luluShowAppCommentWithAppID(string appid);
    //luLuDismissMenu
    public static void loginKitShowAppCommentWithAppID(string appid)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luluShowAppCommentWithAppID(appid);
        }
    }
    [DllImport("__Internal")]
    private static extern void luluAfTrackEvent(string eventName, string eventValue);
    //luLuDismissMenu
    public static void txQKAppsFlyerEvent(string eventName,Dictionary<string, JObject> eventParams)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证事件名称不为空
                if (string.IsNullOrEmpty(eventName))
                {
                    Debug.LogError("Event name cannot be null or empty.");
                    return;
                }
                // 如果参数字典为空，则创建一个新的空字典
                if (paramDict == null)
                {
                    paramDict = new Dictionary<string, JObject>();
                }
                // 将参数字典序列化为JSON字符串
                string jsonString = JsonConvert.SerializeObject(paramDict, Formatting.Indented);
                luluAfTrackEvent(eventName, jsonString);
            }
            catch
            {
            
            }
        }
    }
#endif
}
